*****************************
*USER TO UPDATE FILE LOCATION
*****************************
local location `file'


use "`location'\ms_sentiment_analysis.dta", clear 

egen firmid = group(asxcode)
tsset firmid fyear 


g lk = log(kstock)
g dlk =d.lk
tsset firmid fyear 
g capexratio = capex/l1.kstock

g lsales = log(sales)
tsset firmid fyear
g dlsales = d.lsales
g margin = ebitda/sales 
g roa = ebitda/assets 


drop if fyear < 2003 

*Sentiment measured per 10000 words 
g sentiment = (positive-negative)/total
replace sentiment = sentiment*10000
g unshare = uncertain/total 
replace unshare = unshare*10000

g negshare = negativ/total
replace negshare = negshare*10000
g posshare = posit/total
replace posshare = posshare*10000

*IMPORTANT 
egen minyear = min(fyear)
g trend = fyear-minyear
reg sentiment trend
predict sentiment_res, res
replace sentiment_res = sentiment_res+_b[_cons]

reg unshare trend
predict unshare_res, res
replace unshare_res = unshare_res+_b[_cons]


xtreg negshare trend , fe
predict negshare_res ,res 
replace negshare_res = negshare_res +_b[_cons]
xtreg posshare trend , fe
predict posshare_res ,res 
replace posshare_res = posshare_res +_b[_cons]

su sentiment sentiment_res 

preserve
collapse(mean) sentiment sentiment_res, by(fyear)
twoway (line sentiment fyear) (line sentiment_res fyear)
outsheet using "`location'\sentiment.csv", replace comma
restore


preserve
collapse(mean) unshare unshare_res, by(fyear)
twoway (line unshare fyear) (line unshare_res fyear)
outsheet using "`location'\uncertainty.csv", replace comma
restore

preserve
collapse(mean) posshare posshare_res negshare negshare_res, by(fyear)
outsheet using "`location'\positive_and_negative.csv", replace comma
restore


*IMPORTANT 
rename sentiment sentiment_raw 
rename sentiment_res sentiment 

rename unshare unshare_raw 
rename unshare_res unshare 


**********
*OUTLIERS
**********

destring gics*, replace ignore("NA")

*Utilities & Financials
drop if gics_sector == 55
*drop if gics_sector == 40

drop if kstock <= 0 
drop if inventories < 0 
drop if sales< 0
drop if assets <= 0

drop if qratio < 0 

xtile dlk_nq = dlk, nq(100)
xtile sentiment_nq = sentiment, nq(100)
xtile unshare_nq = unshare, nq(100)
xtile qratio_nq = qratio, nq(100)

g outlier = 0
replace outlier = 1 if dlk_nq == 1 | dlk_nq == 100
replace outlier = 1 if sentiment_nq == 1 | sentiment_nq == 100
replace outlier = 1 if qratio_nq == 1 | qratio_nq == 100
replace outlier = 1 if unshare_nq == 1 | unshare_nq == 100


*RECESSION INDICATOR 
g recession = (fyear == 2009 | fyear == 2010)
replace recession = 1 if fyear == 2020 | fyear == 2021

********************
*GRAPHICAL ANALYSIS
********************

preserve
egen id = group(asxcode)
tsset id fyear 
g dsales = (sales-l1.sales)/(l1.sales+sales)
replace dsales = dsales*100 

collapse(mean) dsales, by(asxcode recession)
twoway (histogram dsales if recession == 1, start(-100) width(10) color(red%30)) (histogram dsales if recession == 0, start(-100) width(10) color(blue%30)), legend(order(1 "Recession" 2 "Boom"))
twoway__histogram_gen dsales if recession == 1 , percent start(-100) width(10) gen(h1 x1)
twoway__histogram_gen dsales if recession == 0 , percent start(-100) width(10) gen(h0 x0)
keep h1 h0 x1 x0
drop if h1 == . 
outsheet using "`location'\growth_distribution_by_recession.csv", comma replace
restore 



*TIME SERIES 
*Change in capital stock 
preserve
drop if outlier == 1
collapse(mean) dlk (median) dlk_med = dlk (p25) dlk_p25 = dlk (p75) dlk_p75 = dlk, by(fyear)
twoway (line dlk fyear) (line dlk_med fyear)
twoway (line dlk_med fyear) (line dlk_p25 fyear) (line dlk_p75 fyear)
outsheet using "`location'\investment_by_year.csv", comma replace
restore

*Sentiment 
preserve
drop if outlier == 1
collapse(mean) sentiment (median) sentiment_med = sentiment (p25) sentiment_p25 = sentiment (p75) sentiment_p75 = sentiment, by(fyear)
twoway (line sentiment fyear) (line sentiment_med fyear)
twoway (line sentiment_med fyear) (line sentiment_p25 fyear) (line sentiment_p75 fyear)
outsheet using "`location'\sentiment_distribution.csv", comma replace
restore

*Sales growth 
preserve
drop if outlier == 1	   
collapse(mean) dlsales (median) dlsales_med = dlsales (p25) dlsales_p25 = dlsales (p75) dlsales_p75 = dlsales, by(fyear)
twoway (line dlsales fyear) (line dlsales_med fyear)
twoway (line dlsales_med fyear) (line dlsales_p25 fyear) (line dlsales_p75 fyear)
g diff = dlsales_p75-dlsales_p25 
twoway line diff fyear 
restore


*Q RATIO 
preserve
drop if outlier == 1
collapse(mean) qratio (median) qratio_med = qratio (p25) qratio_p25 = qratio (p75) qratio_p75 = qratio, by(fyear)
twoway (line qratio fyear) (line qratio_med fyear)
twoway (line qratio_med fyear) (line qratio_p25 fyear) (line qratio_p75 fyear)
outsheet using "`location'\qratio_distribution.csv", comma replace
restore

*UNCERTAINTY 
preserve
drop if outlier == 1
collapse(mean) unshare (median) unshare_med = unshare (p25) unshare_p25 = unshare (p75) unshare_p75 = unshare, by(fyear)
twoway (line unshare fyear) (line unshare_med fyear)
twoway (line unshare_med fyear) (line unshare_p25 fyear) (line unshare_p75 fyear)
outsheet using "`location'\uncertainty_distribution.csv", comma replace
restore

***************
*CROSS SECTIONS 
***************
preserve
drop if sentiment ==.
drop if outlier == 1 
xtile sentiment_dec = sentiment , nq(10)
collapse(mean) dlk capexratio, by(sentiment_dec)
replace dlk = dlk*100
twoway bar dlk sentiment 
outsheet using "`location'\investment_by_sentiment.csv", replace comma
restore

preserve
drop if qratio ==.
drop if outlier == 1 
tsset firmid fyear 
g l1qratio = l1.qratio 
xtile qratio_decile = l1qratio, nq(10)
collapse(mean) dlk capexratio, by(qratio_decile)
replace dlk = dlk*100
twoway bar dlk qratio
outsheet using "`location'\investment_by_qratio.csv", replace comma
restore

preserve
drop if unshare ==.
xtile unshare_dec = unshare, nq(10)
collapse(mean) dlk, by(unshare_dec)
replace dlk = dlk*100
twoway bar dlk unshare
outsheet using "`location'\investment_by_uncertainty.csv", replace comma
restore


*Conditional distribution
preserve
drop if qratio ==.
drop if outlier == 1 
drop if sentiment == . 
drop if dlk == . 
tsset firmid fyear 
xtreg dlk sentiment l1.qratio i.fyear , fe 
xtreg dlk l1.qratio i.fyear ,fe 
predict dlk_residual, res 
xtreg sentiment l1.qratio i.fyear , fe 
predict sentiment_residual, res 
xtreg dlk_residual sentiment_residual , fe 

xtile sentiment_dec = sentiment_residual, nq(10)
collapse(mean) dlk capexratio, by(sentiment_dec)
replace dlk = dlk*100
twoway bar dlk sentiment
restore


********************
*MAIN REGRESSIONS
********************

tsset firmid fyear
g l1lk =l1.lk 
g l1lsales = l1.lsales 
g l1qratio = l1.qratio 

*Two way clustering 
*OLS without controls 
reghdfe dlk sentiment if outlier == 0, cl(firmid fyear) noabsorb
reghdfe dlk sentiment l1.qratio if outlier == 0, cl(firmid fyear) noabsorb
su dlk sentiment if e(sample)
*OLS with controls 
reghdfe dlk sentiment l1.qratio roa dlsales l1lsales l1lk  i.fyear if outlier == 0, cl(firmid fyear) noabsorb
*FE with controls 
reghdfe dlk sentiment l1.qratio roa dlsales l1lsales l1lk i.fyear if outlier == 0, a(firmid) cl(firmid fyear)

*FE with controls AND uncertainty 
reghdfe dlk sentiment l1.qratio unshare roa dlsales l1lsales l1lk i.fyear if outlier == 0, a(firmid) cl(firmid fyear)
su dlk sentiment if e(sample)

*Results still hold with raw indicators
reghdfe dlk sentiment l1.qratio unshare roa dlsales l1lsales l1lk i.fyear if outlier == 0, a(firmid) cl(firmid fyear)


*Summary statistics 
tabstat dlk sentiment posshare negshare qratio unshare roa dlsales  if e(sample), stat(mean, median, sd, p25 , p75)
*Correlation matrix 
corr dlk sentiment qratio unshare roa dlsale if e(sample)

reghdfe dlk sentiment l1.qratio unshare roa dlsales l1lsales l1lk i.fyear if outlier == 0, a(firmid) cl(firmid fyear)
g sample1 = e(sample)
bysort sample1: su dlk sentiment l1qratio unshare roa dlsales if outlier == 0
reghdfe dlk sample1 if outlier == 0, cl(firmid fyear) noabsorb 
reghdfe sentiment sample1 if outlier == 0, cl(firmid fyear) noabsorb 
reghdfe qratio sample1 if outlier == 0, cl(firmid fyear) noabsorb 
reghdfe unshare sample1 if outlier == 0, cl(firmid fyear) noabsorb 

*******************
*Post-GFC weakness 
*******************
g gfc = (fyear == 2009 | fyear == 2010)
g post = (fyear > 2010)
tsset firmid fyear 

preserve 
reghdfe dlk sentiment l1qratio roa unshare dlsales l1.lsales l1.lk gfc post if outlier == 0 , a(firmid) cl(firmid fyear)
g beta_gfc = _b[gfc]
g sterror_gfc = _se[gfc]
g beta_post = _b[post]
g sterror_post = _se[post]
keep beta* sterror* 
keep in 1 
outsheet using "`location'\gfc_controls.csv", replace comma 
restore 

preserve 
reghdfe dlk sentiment l1qratio roa unshare dlsales l1.lsales l1.lk gfc post if outlier == 0 , a(firmid) cl(firmid fyear)
g gfcsample = e(sample)
reghdfe dlk gfc post if outlier == 0 & gfcsample == 1, a(firmid) cl(firmid fyear)
g beta_gfc = _b[gfc]
g sterror_gfc = _se[gfc]
g beta_post = _b[post]
g sterror_post = _se[post]
keep beta* sterror* 
keep in 1 
outsheet using "`location'\gfc_baseline.csv", replace comma 
restore 

preserve 
reghdfe dlk sentiment l1qratio roa unshare dlsales l1.lsales l1.lk gfc post if outlier == 0 , a(firmid) cl(firmid fyear)
g gfcsample = e(sample)
reghdfe dlk sentiment unshare gfc post if outlier == 0 & gfcsample == 1, a(firmid) cl(firmid fyear)
g beta_gfc = _b[gfc]
g sterror_gfc = _se[gfc]
g beta_post = _b[post]
g sterror_post = _se[post]
keep beta* sterror* 
keep in 1 
outsheet using "`location'\gfc_sentiment.csv", replace comma 
restore 


**********************************
*EXTENSION: POSITIVE AND NEGATIVE
**********************************				  

*Sentiment effect is due to both positive and negative share 
reghdfe dlk negshare_res posshare_res if outlier == 0,  cl(firmid fyear) noabsorb 
reghdfe dlk negshare_res posshare_res unshare l1qratio roa dlsales l1lk l1lsales i.fyear if outlier == 0, a(firmid) cl(firmid fyear)

**********************************
*ROBUSTNESS: PROFIT FORECASTS
**********************************				  

*Control for equity analyst profit forecasts  
*Sample size is a lot smaller but sentiment still matters 
replace eps1 = . if eps1 == 0 
g epsoutlier = (eps1 > 10 | eps1 < -1)
replace epsoutlier = . if eps1 == . 
reghdfe dlk sentiment eps1  if outlier == 0 &epsout == 0, noabsorb cl(firmid fyear)
reghdfe dlk sentiment eps1 unshare roa dlsales l1lsales l1lk i.fyear if outlier == 0 &epsout == 0, a(firmid) cl(firmid fyear)

******************************
*ROBUSTNESS: INSIDER KNOWLEDGE
******************************

*Timing structure 
*This allows investors to know more than managers 
reghdfe dlk l1.sentiment qratio  unshare   roa dlsales l1lsales l1lk  i.fyear if outlier == 0, cl(firmid fyear) a(firmid)


*The effect of sentiment is twice as strong for small companies but weaker for young companies 
*SIZE
g small = (assets<10)
g small_sentiment = small*sentiment 
g small_qratio = small*l1qratio 
g small_unshare = small*unshare 
*reghdfe dlk sentiment small_sentiment qratio small_qratio unshare small_unshare roa dlsales l1lsales l1lk  i.fyear if outlier == 0, cl(firmid fyear) a(firmid)
reghdfe dlk sentiment small_sentiment l1qratio small_qratio  unshare  small_unshare roa dlsales l1lsales l1lk  i.fyear if outlier == 0, cl(firmid fyear) a(firmid)

*AGE 
 g age = fyear-listyear 
 replace age = 0 if age == -1 
 replace age = . if age < -1 
 g young = (age < 6)
 g young_sentiment = young*sentiment
 g young_qratio = young*l1qratio 
 g young_unshare = young*unshare
 
reghdfe dlk sentiment young_sentiment l1qratio  young_qratio unshare young_unshare  roa dlsales l1lsales l1lk  i.fyear if outlier == 0, cl(firmid fyear) a(firmid)


*TURNOVER 
 xtile turnover_nq = turnover, nq(4)
 
 g lowturnover = (turnover_nq == 1)
 g low_sentiment = lowturnover*sentiment
 g low_qratio = lowturnover*l1qratio 
 g low_unshare = lowturnover*unshare
 
reghdfe dlk sentiment low_sentiment l1qratio  low_qratio unshare low_unshare roa dlsales l1lsales l1lk  i.fyear if outlier == 0, cl(firmid fyear) a(firmid)

*ALTERNATIVE MEASURE OF CAPITAL SPENDING
g koutlier = outlier 
replace koutlier = 1 if capexratio > 100 & capexratio ~=.
replace koutlier = 1 if capexratio <0
replace koutlier = . if capexratio==.
*Get a positive and significant effect here too 
*Should we include this measure too? 
reghdfe capexratio sentiment l1qratio if koutlier == 0, cl(firmid fyear) noabsorb 
reghdfe capexratio sentiment l1qratio unshare roa dlsales l1lk l1lsale i.fyear if koutlier == 0, cl(firmid fyear) a(firmid)


*Try with different spikes...
g spike = (capexratio > 0.2)
replace spike = . if capexratio == .
reghdfe spike sentiment l1qratio unshare roa dlsales l1lk l1lsales i.fyear if koutlier == 0, cl(firmid fyear) a(firmid)

*******************
*MEASUREMENT ERROR 
*******************

preserve 
reghdfe dlk sentiment l1qratio unshare roa dlsales l1lk l1lsale i.fyear if outlier == 0, cl(firmid fyear) a(firmid)
*IMPORTANT DELETION!!! 
*Otherwise have problem with unbalanced panels here 
keep if e(sample)

foreach i in lk lsales dlk sentiment l1qratio unshare roa dlsales l1lk l1lsales {
qui areg `i', a(firmid) 
qui predict `i'_res, res 
}

*Mean zero when using the `balanced' panel 
su dlk_res sentiment_res l1qratio_res unshare_res roa_res dlsales_res  

*This looks reasonably sensible
*Suggests that ME in Q is a problem 
*Seems very sensitive to changes in specification though 
reghdfe dlk sentiment l1qratio unshare roa dlsales l1lk l1lsales if outlier == 0, cl(firmid fyear) noabsorb 
xtewreg dlk_res l1qratio_res sentiment_res unshare_res roa_res dlsales_res l1lk_res l1lsales_res if outlier == 0, maxdeg(3) mis(1)
xtewreg dlk_res l1qratio_res sentiment_res unshare_res roa_res dlsales_res l1lk_res l1lsales_res if outlier == 0, maxdeg(3) mis(2)
restore


**********************************
*EXTENSION: EMPLOYMENT GROWTH
**********************************				  

g lemp = log(emp)
g lwage = log(wage)
tsset firmid fyear 
g dlemp = d.lemp 
g dlwage = d.lwage 

reghdfe dlemp sentiment l1qratio roa unshare dlsales l1.lsales l1.lk i.fyear if outlier == 0 , a(firmid) cl(firmid fyear)


**********************************************************


******************
*LOCAL PROJECTIONS
******************
reg dlk sentiment l1qratio unshare i.fyear 
g sample = e(sample)
bysort firmid: egen sentiment_mean = mean(sentiment) if sample == 1 
bysort firmid: egen sentiment_sd= sd(sentiment) if sample == 1 
g zsentiment = (sentiment-sentiment_mean)/sentiment_sd
bysort firmid: egen qratio_mean = mean(l1qratio) if sample == 1 
bysort firmid: egen qratio_sd= sd(l1qratio) if sample == 1 
g zqratio = (l1qratio-qratio_mean)/qratio_sd

bysort firmid: egen unshare_mean = mean(unshare) if sample == 1 
bysort firmid: egen unshare_sd= sd(unshare) if sample == 1 
g zunshare = (unshare-unshare_mean)/unshare_sd

bysort firmid: egen posshare_mean = mean(posshare) if sample == 1 
bysort firmid: egen posshare_sd= sd(posshare) if sample == 1 
g zposshare = (posshare-posshare_mean)/posshare_sd
bysort firmid: egen negshare_mean = mean(negshare) if sample == 1 
bysort firmid: egen negshare_sd= sd(negshare) if sample == 1 
g znegshare = (negshare-negshare_mean)/negshare_sd



foreach x in capexratio lk lsale zqratio zunshare zsentiment lemp roa margin {
forv h = 0/6 {
*Use for cumulative IRF
gen f`h'`x' = f`h'.`x' - l.`x'                        
}
}

*DIFFERENT OUTLIERS AT DIFFERENT HORIZONS 
forvalues h = 0/6{
g outlier`h' = 0 
g poutlier`h' = 0 
xtile f`h'lk_nq = f`h'lk, nq(100)
xtile f`h'roa_nq = f`h'roa, nq(100)
replace outlier`h' = 1 if f`h'lk_nq == 1 | f`h'lk_nq == 100
replace poutlier`h' = 1 if f`h'roa_nq == 1 | f`h'roa_nq == 100
}


tsset firmid fyear 
g l1zsentiment = l1.zsentiment 
g l1zqratio = l1.zqratio 
g l1zunshare=l1.zunshare 
g l1dlk = l1.dlk 
g l1capexratio = l1.capexratio 
g l1lemp = l1.lemp 
g l1roa = l1.roa 
g l1margin = l1.margin 

**************
*SENTIMENT LP 
**************
cap drop b u d Years Zero
gen Years = _n-1 if _n<=7
gen Zero =  0    if _n<=7
gen b=0
gen u=0
gen d=0
forv h = 0/6 {
reghdfe f`h'lk zsentiment zqratio zunshare dlsales  roa  l1lk l1lsales l1zsentiment l1zqratio l1zunshare  i.fyear if outlier == 0 , cl(firmid fyear) a(firmid)
replace b = _b[zsentiment]                     if _n == `h'+2
replace u = _b[zsentiment] + 1.645* _se[zsentiment]  if _n == `h'+2
replace d = _b[zsentiment] - 1.645* _se[zsentiment]  if _n == `h'+2
}
preserve 
keep Years b u d 
drop if Years == . 
outsheet using "`location'\irf_sentiment.csv", replace comma 
restore 

twoway (rarea u d  Years,  fcolor(gs13) lcolor(gs13) lw(none) lpattern(solid)) (line b Years, lcolor(blue) lpattern(solid) lwidth(thick)) (line Zero Years, lcolor(black)), legend(off) title("Response of Corporate Investment to 1pp Sentiment Shock", color(black) size(medsmall)) ytitle("Percent", size(medsmall)) xtitle("Year", size(medsmall)) graphregion(color(white)) plotregion(color(white)) 
                      gr rename g_sentiment , replace
 
**************
*Q RATIO LP 
**************
cap drop b u d Years Zero
gen Years = _n-1 if _n<=7
gen Zero =  0    if _n<=7
gen b=0
gen u=0
gen d=0
forv h = 0/6 {
reghdfe f`h'lk zsentiment zqratio  zunshare dlsales roa l1lk l1lsales l1zsentiment l1zqratio l1zunshare  i.fyear if outlier == 0 , cl(firmid fyear) a(firmid)
replace b = _b[zqratio]                     if _n == `h'+2
replace u = _b[zqratio] + 1.645* _se[zqratio]  if _n == `h'+2
replace d = _b[zqratio] - 1.645* _se[zqratio]  if _n == `h'+2
}
preserve 
keep Years b u d 
drop if Years == . 
outsheet using "`location'\irf_qratio.csv", replace comma 
restore 
twoway (rarea u d  Years,  fcolor(gs13) lcolor(gs13) lw(none) lpattern(solid)) (line b Years, lcolor(blue) lpattern(solid) lwidth(thick)) (line Zero Years, lcolor(black)), legend(off) title("Response of Corporate Investment to 1pp Q Shock", color(black) size(medsmall)) ytitle("Percent", size(medsmall)) xtitle("Year", size(medsmall)) graphregion(color(white)) plotregion(color(white)) 
                      gr rename g_qratio , replace

****************
*UNCERTAINTY LP
**************** 

cap drop b u d Years Zero
gen Years = _n-1 if _n<=7
gen Zero =  0    if _n<=7
gen b=0
gen u=0
gen d=0
forv h = 0/6 {
reghdfe f`h'lk l1capexratio zsentiment zqratio  zunshare dlsales roa l1lk l1lsales  l1zsentiment l1zqratio l1zunshare i.fyear if outlier == 0 , cl(firmid fyear) a(firmid)
replace b = _b[zunshare]                     if _n == `h'+2
replace u = _b[zunshare] + 1.645* _se[zunshare]  if _n == `h'+2
replace d = _b[zunshare] - 1.645* _se[zunshare]  if _n == `h'+2
}
preserve 
keep Years b u d 
drop if Years == . 
outsheet using "`location'\irf_uncertainty.csv", replace comma 
restore 
twoway (rarea u d  Years,  fcolor(gs13) lcolor(gs13) lw(none) lpattern(solid)) (line b Years, lcolor(blue) lpattern(solid) lwidth(thick)) (line Zero Years, lcolor(black)), legend(off) title("Response of Corporate Investment to 1pp Uncertainty Shock", color(black) size(medsmall)) ytitle("Percent", size(medsmall)) xtitle("Year", size(medsmall)) graphregion(color(white)) plotregion(color(white)) 
                      gr rename g_uncertainty , replace 


cap drop b u d Years Zero
gen Years = _n-1 if _n<=7
gen Zero =  0    if _n<=7
gen b=0
gen u=0
gen d=0
forv h = 0/6 {
reghdfe f`h'lk zsentiment zqratio zunshare dlsales  roa  l1lk l1lsales l1zsentiment l1zqratio l1zunshare  i.fyear if outlier`h' == 0 , cl(firmid fyear) a(firmid)
replace b = _b[zsentiment]                     if _n == `h'+2
replace u = _b[zsentiment] + 1.645* _se[zsentiment]  if _n == `h'+2
replace d = _b[zsentiment] - 1.645* _se[zsentiment]  if _n == `h'+2
}
preserve 
keep Years b u d 
drop if Years == . 
restore 

twoway (rarea u d  Years,  fcolor(gs13) lcolor(gs13) lw(none) lpattern(solid)) (line b Years, lcolor(blue) lpattern(solid) lwidth(thick)) (line Zero Years, lcolor(black)), legend(off) title("Response of Corporate Investment to 1pp Sentiment Shock", color(black) size(medsmall)) ytitle("Percent", size(medsmall)) xtitle("Year", size(medsmall)) graphregion(color(white)) plotregion(color(white)) 
                      gr rename g_sentiment , replace

					  
**************************************			  
**THE EFFECT ON FUTURE COMPANY VALUE** 
**************************************			  

**************
*SENTIMENT LP 
**************
cap drop b u d Years Zero
gen Years = _n-1 if _n<=7
gen Zero =  0    if _n<=7
gen b=0
gen u=0
gen d=0
forv h = 0/6 {
reghdfe f`h'roa zsentiment zqratio zunshare l1lk l1lsales l1roa l1zsentiment l1zqratio l1zunshare  i.fyear if poutlier`h' == 0 , cl(firmid fyear) a(firmid)
replace b = _b[zsentiment]                     if _n == `h'+2
replace u = _b[zsentiment] + 1.645* _se[zsentiment]  if _n == `h'+2
replace d = _b[zsentiment] - 1.645* _se[zsentiment]  if _n == `h'+2
}
preserve 
keep Years b u d 
drop if Years == . 
outsheet using "`location'\irf_sentiment_profits.csv", replace comma 
restore 

twoway (rarea u d  Years,  fcolor(gs13) lcolor(gs13) lw(none) lpattern(solid)) (line b Years, lcolor(blue) lpattern(solid) lwidth(thick)) (line Zero Years, lcolor(black)), legend(off) title("Response of Corporate Profits to 1pp Sentiment Shock", color(black) size(medsmall)) ytitle("Percent", size(medsmall)) xtitle("Year", size(medsmall)) graphregion(color(white)) plotregion(color(white)) 
                      gr rename g_sentiment , replace
 
  
**************
*Q RATIO LP 
**************
cap drop b u d Years Zero
gen Years = _n-1 if _n<=7
gen Zero =  0    if _n<=7
gen b=0
gen u=0
gen d=0
forv h = 0/6 {
reghdfe f`h'roa zsentiment zqratio zunshare l1lk l1lsales l1roa l1zsentiment l1zqratio l1zunshare  i.fyear if poutlier`h' == 0 , cl(firmid fyear) a(firmid)
replace b = _b[zqratio]                     if _n == `h'+2
replace u = _b[zqratio] + 1.645* _se[zqratio]  if _n == `h'+2
replace d = _b[zqratio] - 1.645* _se[zqratio]  if _n == `h'+2
}
preserve 
keep Years b u d 
drop if Years == . 
outsheet using "`location'\irf_qratio_profits.csv", replace comma 
restore 

twoway (rarea u d  Years,  fcolor(gs13) lcolor(gs13) lw(none) lpattern(solid)) (line b Years, lcolor(blue) lpattern(solid) lwidth(thick)) (line Zero Years, lcolor(black)), legend(off) title("Response of Corporate Profits to 1pp Q Shock", color(black) size(medsmall)) ytitle("Percent", size(medsmall)) xtitle("Year", size(medsmall)) graphregion(color(white)) plotregion(color(white)) 
                      gr rename g_qratio , replace

 